// Generated by CoffeeScript 1.7.1
(function() {
  var endMark, fs, globalPaths, module, path, startMark, util,
    __slice = [].slice;

  fs = require('fs');

  path = require('path');

  module = require('module');

  util = require('util');

  process.type = 'browser';

  process.resourcesPath = path.resolve(process.argv[1], '..', '..', '..', '..');

  process.argv.splice(1, 1);

  startMark = process.argv.indexOf('--atom-shell-switches-start');

  endMark = process.argv.indexOf('--atom-shell-switches-end');

  process.argv.splice(startMark, endMark - startMark + 1);

  globalPaths = module.globalPaths;

  globalPaths.push(path.join(process.resourcesPath, 'atom', 'browser', 'api', 'lib'));

  setImmediate(function() {
    var Readable, app, e, packageJson, packagePath, print, searchPaths, stdin, _i, _len;
    require(path.resolve(__dirname, '..', '..', 'common', 'lib', 'init.js'));
    if (process.platform === 'win32') {
      print = function() {
        var args;
        args = 1 <= arguments.length ? __slice.call(arguments, 0) : [];
        return process.log(util.format.apply(util, args));
      };
      console.log = console.error = console.warn = print;
      process.stdout.write = process.stderr.write = print;
      Readable = require('stream').Readable;
      stdin = new Readable;
      stdin.push(null);
      process.__defineGetter__('stdin', function() {
        return stdin;
      });
    }
    process.on('uncaughtException', function(error) {
      var message, _ref;
      message = (_ref = error.stack) != null ? _ref : "" + error.name + ": " + error.message;
      return require('dialog').showMessageBox({
        type: 'warning',
        title: 'A javascript error occured in the browser',
        message: 'uncaughtException',
        detail: message,
        buttons: ['OK']
      });
    });
    require('app').on('quit', function() {
      return process.emit('exit');
    });
    require('./rpc-server.js');
    packageJson = null;
    searchPaths = ['app', 'app.asar', 'default_app'];
    for (_i = 0, _len = searchPaths.length; _i < _len; _i++) {
      packagePath = searchPaths[_i];
      try {
        packagePath = path.join(process.resourcesPath, packagePath);
        packageJson = JSON.parse(fs.readFileSync(path.join(packagePath, 'package.json')));
        break;
      } catch (_error) {
        e = _error;
        continue;
      }
    }
    if (packageJson == null) {
      throw new Error("Unable to find a valid app");
    }
    app = require('app');
    if (packageJson.version != null) {
      app.setVersion(packageJson.version);
    }
    if (packageJson.productName != null) {
      app.setName(packageJson.productName);
    } else if (packageJson.name != null) {
      app.setName(packageJson.name);
    }
    if (packageJson.desktopName != null) {
      app.setDesktopName(packageJson.desktopName);
    } else {
      app.setDesktopName('#{app.getName()}.desktop');
    }
    require('./chrome-extension.js');
    return module._load(path.join(packagePath, packageJson.main), module, true);
  });

}).call(this);
